SET TERM ^ ;
CREATE OR ALTER PROCEDURE TROVAPREZZICONSCONTI (
    FASCIA Integer,
    ARTICOLO Varchar(20),
    ESTENSIONE Varchar(3),
    QUANTITA Decimal(15,2),
    DATA Date )
RETURNS (
    PREZZONETTO Decimal(15,3),
    PREZZOSCONTATO Decimal(15,3),
    SCONTO Decimal(15,2),
    SCONTOUNO Decimal(15,2),
    SCONTODUE Decimal(15,2),
    SCONTOTRE Decimal(15,2),
    LISTINO_RIF Integer,
    LISTINO_APP Integer,
    PROVVIGIONE Decimal(15,3) )
AS
declare variable COUNTER integer;
declare variable MIGLIORPREZZOMODE smallint;
declare variable VLISTINO integer;
declare variable NLISTINI integer;
declare variable DSQL varchar(700);
declare variable SCONTOSP decimal(15,2);
declare variable SCONTOUNOSP decimal(15,2);
declare variable SCONTODUESP decimal(15,2);
declare variable SCONTOTRESP decimal(15,2);
declare variable RICARICOSP decimal(15,2);
declare variable RICARICOUNOSP decimal(15,2);
declare variable RICARICODUESP decimal(15,2);
declare variable RICARICOTRESP decimal(15,2);
declare variable MIGLIORPREZZONETTO decimal(15,3);
declare variable MIGLIORPREZZOSCONTATO decimal(15,3);
declare variable MIGLIORSCONTO decimal(15,2);
declare variable MIGLIORSCONTOUNO decimal(15,2);
declare variable MIGLIORSCONTODUE decimal(15,2);
declare variable MIGLIORSCONTOTRE decimal(15,2);
declare variable MIGLIORLISTINORIF integer;
declare variable MIGLIORLISTINOAPP integer;
declare variable MIGLIORPROVVIGIONE decimal(15,3);
declare variable LISTINOPREZZIVENDITA integer;
declare variable OMA_SOGLIA Integer;
declare variable OMA_CODICE Varchar(20);
declare variable OMA_ESTENSIONE Varchar(3);
declare variable OMA_QUANTITA Integer;
declare variable OMA_MULTIPLI Integer;
declare variable PRIORITA_SU_ECCPROVV Smallint;
declare variable IDPROMOVELOCE Integer;
BEGIN


    --MATTEO 2012 06 01 se fascia=0 cerco la fascia di default
    IF(FASCIA=0)THEN
    BEGIN
        DSQL='SELECT CAST(TESTO AS INT) FROM TABX WHERE (NOME=''FasciaDefault'')';
        EXECUTE STATEMENT DSQL INTO FASCIA;
    END

    --MATTEO 2012 03 26 modalita miglior prezzo
    migliorprezzoscontato=NULL;
    MIGLIORPREZZOMODE=0;
    DSQL='SELECT COUNT(*) '||
        'FROM    FASCESC '||
        'WHERE   FASCESC.ID='||fascia||' AND FASCESC.CLASSIFICAZIONE1=''MIGLIORPR''';
        EXECUTE STATEMENT DSQL INTO MIGLIORPREZZOMODE;
    IF(MIGLIORPREZZOMODE<>1)THEN
        MIGLIORPREZZOMODE=0;


    --MATTEO 2012 03 20
    --CONTO QUANTI LISTINI CI SONO PER QUESTA FASCIA
    DSQL='SELECT   MAX(FASCESCDT.NRIGA) '||
        'from    FASCESC '||
        'join    FASCESCDT '||
        'ON      FASCESCDT.IDFASCIA=FASCESC.ID '||
        'join    LISTSC '||
        'ON      LISTSC.ID =FASCESCDT.IDLISTINO '||
        'WHERE   (LISTSC.DATAINIZIOVALIDITA IS NULL OR LISTSC.DATAINIZIOVALIDITA<='''||DATA||''') '||
        'AND     (LISTSC.DATAFINEVALIDITA IS NULL OR '''||DATA||'''<=LISTSC.DATAFINEVALIDITA) '||
        'and   FASCESC.ID='||fascia||'';
        EXECUTE STATEMENT DSQL INTO NLISTINI;


    FOR
        SELECT   LISTSC.ID
        FROM    FASCESC
        JOIN    FASCESCDT
        ON      FASCESCDT.IDFASCIA=FASCESC.ID
        JOIN    LISTSC
        ON      LISTSC.ID =FASCESCDT.IDLISTINO
        WHERE   (LISTSC.DATAINIZIOVALIDITA IS NULL OR LISTSC.DATAINIZIOVALIDITA<=:DATA)
        AND     (LISTSC.DATAFINEVALIDITA IS NULL OR :DATA<=LISTSC.DATAFINEVALIDITA)
        AND   FASCESC.ID=:fascia
        ORDER BY FASCESCDT.NRIGA,listsc.DATAINIZIOVALIDITA
        INTO    :vLISTINO
    --MATTEO 2012 03 20
    --FINCHE NON HO TROVATO UN PREZZO PER OGNI LISTINO CERCO SE ESISTE UN PREZZO    
    DO BEGIN
        IF(MIGLIORPREZZOMODE=1 OR prezzoscontato IS NULL OR prezzoscontato=-1)THEN
        BEGIN
            --MATTEO 2020 08 07 risolto errore
            EXECUTE PROCEDURE TROVAPREZZO_LISTINO(:FASCIA,:ARTICOLO,:ESTENSIONE,:DATA,:QUANTITA,:vLISTINO,0)
            RETURNING_VALUES  :prezzonetto,
                              :prezzoscontato,
                              :sconto,
                              :scontouno,
                              :scontodue,
                              :scontotre,
                              :listino_rif,
                              :Listino_app,
                              :provvigione,
                              :oma_soglia,
                              :oma_codice,
                              :oma_estensione,
                              :oma_quantita,
                              :oma_multipli,
                              :PRIORITA_SU_ECCPROVV,
                              :idpromoveloce;
            IF (prezzonetto*prezzoscontato IS NOT NULL AND prezzoscontato<>-1) 
            THEN BEGIN

                --SE SCONTI NULL LI IMPOSTO A ZERO
                IF(sconto IS NULL)THEN
                   sconto=0;
                IF(scontouno IS NULL)THEN
                   scontouno=0;
                IF(scontodue IS NULL)THEN
                   scontodue=0;
                IF(scontotre IS NULL)THEN
                   scontotre=0;

                --CERCO EVENTUALE SCONTO SPECIALE DA APPLICARE
                EXECUTE PROCEDURE APPLICASCONTISPECIALI(:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                RETURNING_VALUES  :scontoSp,
                                  :scontounoSp,
                                  :scontodueSp,
                                  :scontotreSp;
                IF (scontoSp IS NOT NULL)
                THEN BEGIN
                        prezzoscontato=prezzoscontato-prezzoscontato*:scontosp/100;
            
                        IF (scontouno IS NULL OR scontouno=0) THEN
                        BEGIN
                           scontouno=scontounosp;
                           scontodue=scontoduesp;
                           scontotre=scontotresp;
                        END
                        ELSE IF (scontodue IS NULL OR scontodue=0) THEN
                        BEGIN
                           scontodue=scontosp;
                        END
                        ELSE IF (scontotre IS NULL OR scontotre=0) THEN
                        BEGIN
                           scontotre=scontosp;
                        END
                        ELSE
                        BEGIN
                           scontotre=100-((100-scontotre)/100*(100-scontounosp)/100*(100-scontoduesp)/100*(100-scontotresp));
                        END
    
                        sconto=100-((100-scontouno)/100*(100-scontodue)/100*(100-scontotre));
    
                    END
        
                
                --MATTEO 2013 01 07
                DSQL='SELECT COALESCE(CAST(TESTO AS INT),0) FROM TABX WHERE (NOME=''IDListStoPrVen'')';
                EXECUTE STATEMENT DSQL INTO LISTINOPREZZIVENDITA;
                
                
                SELECT   COUNT(*) C
                FROM    LISTSC
                WHERE   (LISTSC.ID=:LISTINO_APP) AND (LISTSC.TIPO='N')
                INTO    :COUNTER;
                IF ((:COUNTER=1) AND (:LISTINOPREZZIVENDITA<>:LISTINO_APP)) THEN
                BEGIN
                    --CERCO EVENTUALE SCONTO SPECIALE NETTO DA APPLICARE
                    EXECUTE PROCEDURE APPLICASCONTISPECIALINETTI(:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                    RETURNING_VALUES  :scontoSp,
                                      :scontounoSp,
                                      :scontodueSp,
                                      :scontotreSp;
                    IF (scontoSp IS NOT NULL)
                    THEN BEGIN
                        prezzoscontato=prezzoscontato-prezzoscontato*:scontosp/100;
            
                        IF (scontouno IS NULL OR scontouno=0) THEN
                        BEGIN
                           scontouno=scontounosp;
                           scontodue=scontoduesp;
                           scontotre=scontotresp;
                        END
                        ELSE IF (scontodue IS NULL OR scontodue=0) THEN
                        BEGIN
                           scontodue=scontosp;
                        END
                        ELSE IF (scontotre IS NULL OR scontotre=0) THEN
                        BEGIN
                           scontotre=scontosp;
                        END
                        ELSE
                        BEGIN
                           scontotre=100-((100-scontotre)/100*(100-scontounosp)/100*(100-scontoduesp)/100*(100-scontotresp));
                        END
    
                        sconto=100-((100-scontouno)/100*(100-scontodue)/100*(100-scontotre));
    
                    END
                END

                --CERCO EVENTUALE RICARICO DA APPLICARE
                EXECUTE PROCEDURE APPLICARICARICO(:FASCIA,:ARTICOLO,:ESTENSIONE,:QUANTITA,:DATA)
                RETURNING_VALUES  :RICARICOSP,:RICARICOUNOSP,:RICARICODUESP,:RICARICOTRESP;
                IF (ricaricoSp IS NOT NULL)
                THEN BEGIN
                    prezzoscontato=prezzoscontato+prezzoscontato*:ricaricoSp/100;
                    prezzonetto=prezzonetto+prezzonetto*:ricaricoSp/100;
                END
        
                IF(MIGLIORPREZZOMODE=1)THEN
                BEGIN
                    IF(migliorprezzoscontato IS NULL OR prezzoscontato<migliorprezzoscontato)THEN
                    BEGIN
                         migliorprezzoscontato=prezzoscontato;
                         migliorprezzonetto=prezzonetto;
                         migliorsconto=sconto;
                         migliorscontouno=scontouno;
                         migliorscontodue=scontodue;
                         migliorscontotre=scontotre;
                         migliorlistinorif=listino_rif;
                         migliorlistinoapp=listino_app;
                         migliorprovvigione=provvigione;
                    END
                END
                ELSE
                BEGIN

                    IF(provvigione IS NULL)THEN
                        provvigione=0;

                    SUSPEND;
                    EXIT;
                END
            
            
            END

        END

        NLISTINI=NLISTINI-1;
       
        
    END



    --MATTEO 2012 03 26 se modalita miglior prezzo ritorno quello trovato (se trovato)
    IF(MIGLIORPREZZOMODE=1)THEN
    BEGIN
       IF(MIGLIORPREZZOSCONTATO IS NOT NULL OR MIGLIORPREZZOSCONTATO<>-1)THEN
       BEGIN
          prezzoscontato=migliorprezzoscontato;
          prezzonetto=migliorprezzonetto;
          sconto=migliorsconto;
          scontouno=migliorscontouno;
          scontodue=migliorscontodue;
          scontotre=migliorscontotre;
          listino_rif=migliorlistinorif;
          listino_app=migliorlistinoapp;
          provvigione=migliorprovvigione;
          
          IF(provvigione IS NULL)THEN
             provvigione=0;
          
          SUSPEND;
          EXIT;
       END
    END



    --MATTEO 2012 03 20
    --SE NON TROVO ALCUN PREZZO RITORNO QUELLO IN ANAMAG
    DSQL='SELECT  PREZZOVENDITA '||
    'FROM ANAMAG '||
    'WHERE CODICE='''||articolo||''' ';
    IF(estensione='0')THEN
       DSQL=DSQL||'AND (TRIM(ESTENSIONE)='''' OR ESTENSIONE IS NULL) ';
    ELSE
       DSQL=DSQL||'AND ESTENSIONE='''||estensione||''' ';
    

    EXECUTE STATEMENT DSQL INTO prezzonetto;
    prezzoscontato=prezzonetto;
    sconto=0;
    scontouno=0;
    scontodue=0;
    scontotre=0;
    provvigione=0;
    
    IF(prezzoscontato IS NULL)THEN
      prezzoscontato=0;
    
    IF(prezzonetto IS NULL)THEN
       prezzonetto=0;



    Listino_app=-1;
    --PREZZOscontato=-1;
    SUSPEND;
    
END^
SET TERM ; ^


GRANT EXECUTE
 ON PROCEDURE TROVAPREZZICONSCONTI TO  SYSDBA;

